        program main
C-----------------------------------------------------------------|      
C       Basic Finite Element Program      |
C-----------------------------------------------------------------|
C                    FEB
C-----------------------------------------------------------------|
C           FEB  PROGRAM        - Plane stress elements           |
C                               - Plane strain elements           |
C                               - 4-node isoparametric elements   |
C                                                                 |
C             M. Ghaemian                                         |
C             Sharif University of Technology                     |
C             Civil Engineering Department                        |
C-----------------------------------------------------------------|
      implicit double precision (a-h,o-z)
      character*1 fin,ext
      common ia(1500000)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /andat/ rdis,kswt,kdis,kfrc,ktmp,khdr,kseis,keig,nrdof(2)
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
      common /seismic/ am,bk,apha,bta,gama,dt,tt,ddat,dme,dmf,ic,kpd,kac
      common /bacup/ nvec,imass,idead,iep0,ifalse(8)
      common /parc/ fin(12),ext(80)
c
      call ioset
      call sclear
      write (ntm,1000)
C-----OBTAIN INPUT FILE NAME ------------------------
      write (ntm,1001)
      read (*,2001) fin
      call fopen(-nin,'inp')
C-----OPEN OUTPUT FILE NAMED ???.OUT ----------------
  75  call nopen(-not,'out ')
      write (not,1000)
      call free
      call freept
      call timefn
C----------------------------------------------------
      mtot =1500000
      call izero (ia,mtot)
      call izero (nummat,9)
      call izero (icrack,9)
C
C     READ THE TITLE CARD FROM INUT FILE AND PRINT
C
      write (ntm,2000)
C
C     READ THE CONTROL IFORMATION
C
C      NUMMAT=num of matrials, NUMNP=number of nodal points,
C      NUMEL=number of elements, ICRACK=switch requesting
C      crack analysis
C
C      NDATAM=no. of data items in material cards
C
C
      k=0
      call find ('CTRL',k)
      if (k .ne. 0) then
         write (ntm,2002)
         write (ntm,2002)
         stop
      else
         continue
      endif
c
      prd1=0.d0
      nvec=1
      btol=1.0d-5
      ftol=1.0d-3
      rtn=0.d0
      fact=1.d0
c
      iconv=0
      ener0=0.d0
      enerb0=0.d0
      diss0=0.d0
c
      call free
      call freei ('M',nummat,1)
      call freei ('N',numnp,1)
      call freei ('E',numel,1)
      call freei ('C',icrack,1)
      call freer ('G',axgrv,1)
      call freer ('F',fact,1)
      call freei ('I',nter,1)
      call freei ('S',ks,1)
      call freer ('T',btol,1)
      call freer ('L',ftol,1)
      call freer ('R',rtn,1)
      call freei ('U',ipor,1)
C
C     ECHO PRINT OF CONTROL INFORMATION
C
      write (not,2003) nummat,numnp,numel,icrack,axgrv,fact,nter,ks,
     +btol,ftol,rtn,ipor
      if (nter .lt. 0) then
         ipd=1
         nter=-nter
      endif
      if (icrack .ne. 0) then
         ndatam=8
      else
         ndatam=5
         ipd=0
      endif
c
c     Reserve space in the array IA for
c
c      material data = E,NU,unit weight,sigmat,Gf,beta
c                    = (nummat x ndatam x 2) spaces
c      nodal data=Restraints (numnp x 2) spaces
c      nodal coordinates=x and y coordinates (numnp x 4) spaces
c      element data=nodes,material ID
c                  =(numel x 5) spaces
c
      write (ntm,2004)
      write (not,2004)
c
      lmat=1
      lnode=lmat+nummat*ndatam*2
      llast=lnode+numnp*3
      call defr (llast,lcoord,numnp*4)
      lele=llast
      lcode=lele+numel*5
      lface=lcode+numel
      llast=lface+numel
c
      if (llast .gt. mtot) call termi (llast,mtot)
      lavail=mtot-llast
      write (not,2005) llast,lavail
c
      call inpu (iflag,ndatam,ia(lmat),ia(lnode),ia(lcoord),ia(lele),
     + ia(lface),ia(lcode),fact)
      llast=lface+nlar*2+2
c.....Error in input data file
      if (iflag .ne. 0) then
         write (ntm,2006) iflag
         write (not,2006) iflag
         stop
      else
         continue
      endif
c.....Assign equation numbers to free dof
      call eqnum (ia(lnode))
      neqq=neq+1
c.....Generate the initial stiffness matrix for each element, and
c.....the diagonal address sequence of global stiffness matrix.
      write (not,2007)
      write (ntm,2007)
c
      ladres=llast
      llast=ladres+neqq
      call defr (llast,ldmat,nummat*8)
      lbdat=llast
      lcheck=lbdat+numel*72
      llast=lcheck+numnp
      if (llast .gt. mtot) call termi (llast,mtot)
c
      call stiff (ndatam,ia(lmat),ia(lnode),ia(lcoord),ia(lele),
     +ia(ldmat),ia(ladres),ia(lbdat),ia(lcheck))
      llast=lcheck
c.....modifications for windows operations
      llmdat=llast
      if (icrack .ne. 0) then
         lekdat=llmdat+(numel+nbms)*8
         llast=lekdat+(numel+nbms)*128
      else
         lekdat=llmdat+nbms*8+2
         llast=lekdat+nbms*128+2
      endif
      call readek (ia(llmdat),ia(lekdat),icrack)
c
      ldisp=llast
      lresid=ldisp+neqq*2
      ldumy=lresid+neqq*2
      kkdum=max0(numnp*4,neqq*2)
      leres=ldumy+kkdum
      kkdum=max0(numel*8,neqq*2,numnp*4)
      lstiff=leres+kkdum
      llast=lstiff+nsto*2
c.....for windows run, the bakup file operations are done in the core
      lwindo=llast
      llast=lwindo+neqq*20+numel*8
c.....check for specified load components
      call loadcmp
c.....check for pore pressure effects in cracks and joints
      lporel=llast
c.....Modify the following line if dynamic pressure needs to be computated
c.....even in uncraked elements during seismic analyses
c.....
      if (khdr .eq. 0  .or.  icrack .eq. 0) ipor=0
c.....
      if (ipor .eq. 0) then
         llast=lporel+8
      else
c........Initial pore-pressures in the Gauss points are stored
         llast=lporel+numel*8
      endif
      if (llast .gt. mtot) call termi (llast,mtot)
c.....space for seismic analysis
      if (kseis .eq. 0) go to 70
         lspr=llast
         if (ipor .ne. 0) then
            llast=lspr+neqq*2
         else
            llast=lspr+2
         endif
         lmass=llast
         ldamp=lmass+neqq*2
c         lvelo=ldamp+neqq*2
         lvelo=ldamp+nsto*2
         lacce=lvelo+neqq*2
         leqdt=lacce+neqq*2
         llast=leqdt
         if (llast .gt. mtot) call termi (llast,mtot)
         call eqdat (ia(leqdt),llast,mtot,axgrv)
   70 continue
c.....define space for crack propagation analysis
c                               allowed maximum no. of cracks=nlar*2
      lnck=llast
      llast=lnck+2*nlar+2
      if (llast .gt. mtot) call termi (llast,mtot)
      call defr (llast,lcrck,2)
      lavail=mtot-lcrck
      write (not,2005) llast,lavail
      if (icrack .eq. 0) go to 80
c
      if (ipor .ne. 0) then
         ndt=(46+4)+14
      else
         ndt=46+4
      endif
      mxk=lavail/ndt
      if (mxk .lt. numel) then
         write (not,2008) mxk
         write (ntm,2008) mxk
      else
         continue
      endif
c.....check for pre-cracked elements with orthotropic properties
c
   80 continue
      llast=lcrck+ncel*ndt+2
      ltmp=llast
      lwet=ltmp+nummat*4
      llast=lwet+numnp
	call defr(llast,lnstress,numnp*8)
      if (llast .gt. mtot) call termi (llast,mtot)
      call loads (ndatam,ia(lmat),ia(lnode),ia(lele),ia(ldmat),
     +ia(lresid),ia(ldumy),ia(leres),ia(ltmp),ia(lcode),ia(lcrck),
     +ia(lcoord),ia(lwet),kdead,axgrv,ia(lwindo),ia(lporel),
     +ia(lbdat),ia(lnck),ia(llmdat),ia(lekdat))
      call izero (ia(ltmp),llast-ltmp)
c.....Check for eigen solution
      if (keig .eq. 0) go to 100
         write (not,3001)
         write (ntm,3001)
         llast=lcrck+ncel*ndt+2
         mavl=mtot-llast
         if (keig .lt. 0) then 
c           meig=-keig
            meig=1
         else
            meig=keig
         endif
         call assmk0 (ia(ladres),ia(lstiff),ia(llmdat),ia(lekdat),
     +   icrack)
         call eigsol (ia(ladres),ia(lstiff),ia(llast),neq,nsto,0.D0,
     +   meig,mavl,imass,ia(lwindo),prd1)
  100 continue
c.....Solve for specified static loads (self weight, hydro-static pressure, 
c     uplift force, temperature)
      if (kdead .eq. 0) go to 200
         write (not,2009)
         write (ntm,2009)
         call bakup (ia(ldumy),neq,-idead,ia(lwindo))
         call assmk0 (ia(ladres),ia(lstiff),ia(llmdat),ia(lekdat),
     +   icrack)
         call optsol (ia(lstiff),ia(lresid),ia(ladres),numeqn,1,1,1)
         call solve (ia(ldisp),ia(lnode),ia(lele),ia(leres),ia(lnstress)
     +   ,ia(ldmat),
     +   ia(lcode),ia(lcrck),ia(ldumy),ndatam,ia(lmat),ia(lface),neq,
     +   neq,btol,ia(ladres),ia(lstiff),ia(lcoord),ia(lresid),iconv,
     +   ia(lnck),nter,ener0,diss0,0.d0,false2,false3,kstiff,ia(lwindo),
     +   ia(llmdat),ia(lekdat),ia(lbdat),ia(lporel),0,enerb0,nbms)
         call copr (ia(ldumy),ia(lresid),neq)
  200 continue
      dtm=0.D0
      if (kseis .ne. 0) then
          write (not,2011)
          write (ntm,2011)
          call save (ia(ldisp),ia(lacce),ia(leres),ia(ldumy),ia(lnode),
     +    dtm)
c          call nseis (ndatam,ia(lmat),ia(lnode),ia(lele),ia(lface),
c     +    ia(ldmat),ia(ldisp),ia(lstiff),ia(ladres),ia(lnck),ia(lcode),
c     +    ia(lcrck),ia(lcoord),ia(ldumy),ia(leres),ia(lresid),ia(ldamp),
c     +    ia(lvelo),ia(lacce),ia(leqdt),ia(lmass),ener0,diss0,btol,
c     +    ia(lwindo),ia(llmdat),ia(lekdat),ia(lbdat),prd1,
c     +    ia(lporel),ia(lspr),enerb0)
      else
         if (kdis .ne. 0  .or.  kfrc .ne. 0  .or.  khdr .ne. 0) then
            call save (ia(ldisp),ia(lresid),ia(leres),ia(ldumy),
     +      ia(lnode),dtm)
            write (not,2012)
            write (ntm,2012)
            call disps (ndatam,ia(lmat),ia(lnode),ia(lele),ia(lface),
     +      ia(ldmat),ia(ldisp),ia(lstiff),ia(ladres),ia(lnck),
     +      ia(lcode),ia(lcrck),ia(lcoord),ia(ldumy),ia(leres),
     +      ia(lnstress),ia(lresid),ener0,diss0,btol,ia(lwindo),
     +      ia(llmdat),ia(lekdat),ia(lbdat),prd1,ia(lporel),enerb0)
         else
            call save (ia(ldisp),ia(lresid),ia(leres),
     +      ia(ldumy),ia(lnode),dtm)
		  call tecplot(ia(lcoord),ia(lele),ia(lnstress))
         endif
      endif
  300 continue
      call timefn
C     ---------------------------------------------------------------------
 1001 format(/
     . ' Enter the input file name ( 1 to 8 Characters):')
C     ---------------------------------------------------------------------
 1000 format (/10x,
     +' |-----------------------------------------------------------|',/
     +10x,
     +' |                           FEB.for                         |',/
     +10x,
     +' |   A Basic Finite Element program to predict the Stress    |',/
     +10x,
     +' |                response of concrete structures            |',/
     +10x,
     +' |                                                           |',/
     +10x,
     +' |                          Developed by                     |',/
     +10x,
     +' |                       Dr. M. Ghaemian                     |',/
     +10x,
     +' |                                                           |',/
     +10x,
     +' |    First version: 84-1             Current version: 85-2  |',/
     +10x,
     +' |-----------------------------------------------------------|',/
     +10x,
     +' |      IT IS THE RESPONSIBILITY OF THE USER TO VERIFY AND   |',/
     +10x,
     +' |                   INTERPRET THE RESULTS                   |',/
     +10x,
     +' |-----------------------------------------------------------|'/)
c
 2000 format(//' PROGRAM STARTS READING THE INPUT FILE '/)
 2001 format (12a1)
 2002 format (/' THE CONTROL CARD WTIH THE KEY WORD CTRL IS MISSING'/
     .' PROGRAM STOPS. CHECK THE INPUT FILE')
 2003 format (//' THE CONTROL INFORMATION AS READ FROM THE INPUT FILE'/
     +/' Number of material properties:      ',i4,
     +/' Number of nodal points:             ',i4,
     +/' Number of elements:                 ',i4,
     +/' Switch for crack analysis    :      ',i4,
     +/' Acceleration due to gravity  :',f10.3,
     +/' Coordinates are scaled by    :',f10.3,
     +/' Iteration code               :      ',i4,
     +/' Stiffness formulation code   :      ',i4,
     +/' Global tolerance             :',e10.5,
     +/' Local tolerance              :',e10.5,
     +/' Threshold vaule for rotation of crack:',f10.5,
     +/' Pore pressure analysis code          :',i4)
 2004 format (//10X,'GOING TO STORE THE GEOMETRY DATA')
 2005 format (/' Required storage space: ',I10/' Remaining storage',
     +' space:',I10/)
 2006 format (' IMPROPER DATA FILE. THE PROGRAM STOPS.'/' CHECK THE 
     + INPUT FILE FOR',i2,' ERROR MESSAGES')
 2007 format (//10X,' GOING TO GENERATE THE ELEMENT STIFFNESS MATRICES')
 2008  format (/' ******************* WARNING ***************'/
     +/' ONLY',I3,' ELEMENTS CAN BE ALLOWED TO CRACK'/)
 2009 format (//10X,'SOLVING FOR SEPCIFIED DEAD LOADS')
 2011 format (//10x,'** GOING FOR TIME DOMAIN SEISMIC ANALYSIS **')
 2012 format (//10X,'** GOING FOR INCREMENTAL STATIC SOLUTION **')
 3001 format (//10X,' GOING TO SOLVE THE EIGENVALUE PROBLEM')
 4000 format (6(F5.2,F5.3))

c
      stop
      end